﻿using NVCC.Models;
using NVCC.WebUI.Utilities;
using System;

namespace NVCC.WebUI.Models
{
    [Serializable]
    public class AuthorizationViewModel
    {
        public AuthorizationViewModel()
        {
        }
        public AuthorizationViewModel(Authorization authorization)
        {
            if (authorization == null)
                throw new NullReferenceException("authorization");

            Authorization = authorization;
            var modifiedAuthText = authorization.AuthorizationText.Replace("\n", " ");

            DescriptionOfSpecialty = GetDescriptionOfSpecialty(modifiedAuthText);
            Urgency = GetUrgency(modifiedAuthText);
            ClinicallyIndicatedDate = GetClinicallyIndicatedDate(modifiedAuthText);
            EligiblityVerificationDate = GetEligibilityVerficationDate(modifiedAuthText);

        }


        public string DescriptionOfSpecialty { get; private set; }
        public string Urgency { get; private set; }
        public string ClinicallyIndicatedDate { get; private set; }
        public string EligiblityVerificationDate { get; private set; }
        public Authorization Authorization { get; set; }

        private string GetClinicallyIndicatedDate(string modifiedAuthText)
        {
            var clinicallyIndicatedDateStartText = "Clinically Indicated Date: ";
            var clinicallyIndicatedDateStopText = "Description of Specialty:";
            string clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText,
                clinicallyIndicatedDateStopText);

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                clinicallyIndicatedDateStopText = "Description of Specific Services and Medical Specialist:";
                clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText, clinicallyIndicatedDateStopText);
            }

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                // Needs to be before Date VA Requests services under Provider Agreement|Veteran Information because these would match those as well.
                clinicallyIndicatedDateStartText = "Date VA Requests services under Provider Agreement:";
                clinicallyIndicatedDateStopText = "Appointment Comment";
                clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText, clinicallyIndicatedDateStopText);
            }

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                clinicallyIndicatedDateStartText = "Date VA Requests services under Provider Agreement:";
                clinicallyIndicatedDateStopText = "Veteran Information:";
                clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText, clinicallyIndicatedDateStopText);
            }

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                // must be before Clinically Indicated Date (CID)|Category of Care/Type of Special test because these notes will match that as well.
                clinicallyIndicatedDateStartText = "Clinically Indicated Date (CID):";
                clinicallyIndicatedDateStopText = "Service other than Tele Mental Health";
                clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText, clinicallyIndicatedDateStopText);
            }

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                // must be before Clinically Indicated Date (CID)|Category of Care/Type of Special because this has tigher leader text
                clinicallyIndicatedDateStartText = "as the first scheduled appointment)";
                clinicallyIndicatedDateStopText = "Category of Care/Type of Special"; // Specialty or Specialist
                clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText, clinicallyIndicatedDateStopText);
            }

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                clinicallyIndicatedDateStartText = "Clinically Indicated Date (CID):";
                clinicallyIndicatedDateStopText = "Category of Care/Type of Special"; // Specialty or Specialist
                clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText, clinicallyIndicatedDateStopText);
            }

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                clinicallyIndicatedDateStartText = "Clinically Indicated Date (CID):";
                clinicallyIndicatedDateStopText = "Tele Mental Health";
                clinicallyIndicatedDate = StringHelper.GetParsedText(modifiedAuthText, clinicallyIndicatedDateStartText, clinicallyIndicatedDateStopText);
            }

            if (string.IsNullOrEmpty(clinicallyIndicatedDate))
            {
                clinicallyIndicatedDate = "N/A";
            }
            return clinicallyIndicatedDate.Trim();
            //need comma in date.
            //return StringHelper.RemoveNonAlphaNumeric(clinicallyIndicatedDate);
        }
        private string GetUrgency(string modifiedAuthText)
        {
            var urgencyStartText = "Please select urgency: ";
            var urgencyStopText = "Clinically Indicated Date:";
            string urgency = StringHelper.GetParsedText(modifiedAuthText, urgencyStartText, urgencyStopText);

            if (string.IsNullOrEmpty(urgency) || urgency.Length > 20)
            {
                urgencyStopText = "To facilitate Urgent Scheduling";
                urgency = StringHelper.GetParsedText(modifiedAuthText, urgencyStartText, urgencyStopText);
            }

            if (string.IsNullOrEmpty(urgency) || urgency.Length > 20)
            {
                urgencyStartText = "Please select referral urgency";
                urgencyStopText = "To facilitate";
                urgency = StringHelper.GetParsedText(modifiedAuthText, urgencyStartText, urgencyStopText);
            }

            if (string.IsNullOrEmpty(urgency) || urgency.Length > 40)
            {
                urgencyStartText = "Please select referral urgency: ";
                urgencyStopText = "If URGENT, indicate timeframe";

                urgency = StringHelper.GetParsedText(modifiedAuthText, urgencyStartText, urgencyStopText);
            }

            if (string.IsNullOrEmpty(urgency) || urgency.Length > 40)
            {
                urgencyStartText = "Please select referral urgency: ";
                urgencyStopText = "If ROUTINE, indicate time";

                urgency = StringHelper.GetParsedText(modifiedAuthText, urgencyStartText, urgencyStopText);
            }

            if (string.IsNullOrEmpty(urgency) || urgency.Trim().Length > 40)
            {
                urgencyStartText = "Please select referral urgency: ";
                urgencyStopText = "If Routine, indicate time";

                urgency = StringHelper.GetParsedText(modifiedAuthText, urgencyStartText, urgencyStopText);
            }
            if (string.IsNullOrEmpty(urgency))
            {
                urgencyStartText = "Referral Urgency:";
                urgencyStopText = "Indicate time frame for appointment";
                urgency = StringHelper.GetParsedText(modifiedAuthText, urgencyStartText, urgencyStopText);
            }

            if (string.IsNullOrEmpty(urgency))
            {
                urgency = "UNK";
            }
            return StringHelper.RemoveNonAlphaNumeric(urgency).Trim();
        }

        private string GetDescriptionOfSpecialty(string modifiedAuthText)
        {
            var dosStartText = "Category:";
            var dosStopText = "Type of Spec";
            string returnText = StringHelper.GetParsedText(modifiedAuthText, dosStartText, dosStopText).Trim();
            if (string.IsNullOrEmpty(returnText))
            {
                dosStartText = "Description of Specialty: ";
                dosStopText = "Eligibility Verification:";
                returnText = StringHelper.GetParsedText(modifiedAuthText, dosStartText, dosStopText);
            }
            if (string.IsNullOrEmpty(returnText))
            {
                dosStartText = "Description of Specific Services and Medical Specialist: ";
                returnText = StringHelper.GetParsedText(modifiedAuthText, dosStartText, dosStopText);
            }
            if (string.IsNullOrEmpty(returnText))
            {
                dosStartText = "(i.e. Cardiology, Dermatology, Neurology)";
                dosStopText = "Type of Specialist:";
                returnText = StringHelper.GetParsedText(modifiedAuthText, dosStartText, dosStopText);
            }
            if (string.IsNullOrEmpty(returnText))
            {
                dosStartText = "Specialty:";
                dosStopText = "Type of Specialist:";
                returnText = StringHelper.GetParsedText(modifiedAuthText, dosStartText, dosStopText);
            }
            if (string.IsNullOrEmpty(returnText))
            {
                if (!string.IsNullOrEmpty(StringHelper.GetParsedText(modifiedAuthText, "Clinically Indicated Date (CID):", "Tele Mental Health")))
                {
                    returnText = "Tele Mental Health";
                }
            }
            if (string.IsNullOrEmpty(returnText))
            {
                returnText = "UNK";
            }
            return StringHelper.RemoveNonAlphaNumeric(returnText.Trim());
        }

        private string GetEligibilityVerficationDate(string modifiedAuthText)
        {
            var eligibilityVerificationDateStartText = "Eligibility was verified on: ";
            var eligibilityVerificationDateStopText = "Non-VA Care Program Manager or equivalent:";
            var eligibilityVerificationDate = StringHelper.GetParsedText(modifiedAuthText,
                eligibilityVerificationDateStartText, eligibilityVerificationDateStopText);

            if (string.IsNullOrEmpty(eligibilityVerificationDate))
            {
                eligibilityVerificationDateStartText = "Veterans Choice Viewer application (VA Viewer) on:";
                eligibilityVerificationDateStopText = "Veteran Other Health Insurance (OHI):";
                eligibilityVerificationDate = StringHelper.GetParsedText(modifiedAuthText,
                 eligibilityVerificationDateStartText, eligibilityVerificationDateStopText);
            }

            if (string.IsNullOrEmpty(eligibilityVerificationDate))
            {
                eligibilityVerificationDateStartText = "Veterans Choice Viewer application (VA Viewer) on:";
                eligibilityVerificationDateStopText = "Non-VA Care Program Manager or equivalent";
                eligibilityVerificationDate = StringHelper.GetParsedText(modifiedAuthText,
                eligibilityVerificationDateStartText, eligibilityVerificationDateStopText);
            }

            if (string.IsNullOrEmpty(eligibilityVerificationDate))
            {
                eligibilityVerificationDateStartText = "Veterans Choice Viewer application (VA Viewer) on:";
                eligibilityVerificationDateStopText = "Service-Connected(SC) and/or Special Authority(SA):";
                eligibilityVerificationDate = StringHelper.GetParsedText(modifiedAuthText,
                eligibilityVerificationDateStartText, eligibilityVerificationDateStopText);
            }

            if (string.IsNullOrEmpty(eligibilityVerificationDate))
            {
                eligibilityVerificationDateStartText = "Choice Viewer application (VC Viewer)";
                eligibilityVerificationDateStopText = "Contact the Local VA Office of Community Care";
                eligibilityVerificationDate = StringHelper.GetParsedText(modifiedAuthText,
                eligibilityVerificationDateStartText, eligibilityVerificationDateStopText);
                if (!string.IsNullOrEmpty(eligibilityVerificationDate))
                {
                    if (eligibilityVerificationDate.Trim().Length >= 4)
                    { // make sure it is long enough to not throw error in Remove
                        eligibilityVerificationDate = eligibilityVerificationDate.Trim().Remove(0, 4);
                    }
                    else
                    {
                        eligibilityVerificationDate = "";
                    }
                }
            }

            if (string.IsNullOrEmpty(eligibilityVerificationDate))
            {
                eligibilityVerificationDateStartText = "application (VC Viewer) on:";
                eligibilityVerificationDateStopText = "Local VA Office of Community Care";
                eligibilityVerificationDate = StringHelper.GetParsedText(modifiedAuthText,
                eligibilityVerificationDateStartText, eligibilityVerificationDateStopText);
            }

            if (string.IsNullOrEmpty(eligibilityVerificationDate))
            {
                eligibilityVerificationDate = "UNK";
            }

            return eligibilityVerificationDate.Trim();
        }


    }
}